<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

define("ADMINAREA", true);
require dirname(__DIR__) . "/init.php";
$aInt = new WHMCS\Admin("Health and Updates");
$aInt->title = AdminLang::trans("healthCheck.title");
$aInt->sidebar = "";
$aInt->icon = "support";
$smartyValues = [];
$healthChecks = new WHMCS\View\Admin\HealthCheck\HealthCheckRepository();
$keyChecks = $healthChecks->keyChecks();
$nonKeyChecks = $healthChecks->nonKeyChecks();
$allChecks = $keyChecks->merge($nonKeyChecks);
$export = App::get_req_var("export");
if ($export) {
    $exportData = [];
    foreach ($nonKeyChecks as $check) {
        $body = $textBody = $check->getBody();
        $body = str_replace("<ul>", " ", $body);
        $body = str_replace("</li>", " ", $body);
        $body = str_replace("</ul>", ".", $body);
        $exportData["json"][$check->getSeverityLevel()][$check->getName()] = strip_tags($body);
        $textBody = str_replace("<li>", " - ", $textBody);
        $textBody = str_replace("</li>", "\n", $textBody);
        $textBody = str_replace("<ul>", "\n", $textBody);
        $exportData["text"][$check->getSeverityLevel()][$check->getName()] = strip_tags($textBody);
    }
    if ($export == "json") {
        $aInt->setBodyContent($exportData["json"]);
        $aInt->output(defined("JSON_PRETTY_PRINT") ? JSON_PRETTY_PRINT : NULL);
        throw new WHMCS\Exception\ProgramExit();
    }
    if ($export == "text") {
        header("Content-type: text/plain");
        echo "WHMCS Health Check\n================================================================================\n";
        foreach ($exportData["text"] as $severity => $values) {
            echo "\n" . $severity . ":\n";
            foreach ($values as $value) {
                $strings = explode("\n", wordwrap($value, 77));
                $firstLine = array_shift($strings);
                echo " * " . $firstLine . "\n";
                if ($strings) {
                    foreach ($strings as $string) {
                        echo "   " . $string . "\n";
                    }
                }
            }
        }
        throw new WHMCS\Exception\ProgramExit();
    }
}
$smartyValues["totalChecks"] = $keyChecks->count() + $nonKeyChecks->count();
$smartyValues["checks"] = $allChecks->reduce(function ($results, WHMCS\View\Admin\HealthCheck\HealthCheckResult $result) {
    $results = is_null($results) ? [] : $results;
    $result->getSeverityLevel();
    switch ($result->getSeverityLevel()) {
        case PSR\Log\LogLevel::INFO:
        case PSR\Log\LogLevel::NOTICE:
            $results["success"][] = $result;
            break;
        case PSR\Log\LogLevel::WARNING:
            $results["warning"][] = $result;
            break;
        case PSR\Log\LogLevel::ERROR:
        case PSR\Log\LogLevel::CRITICAL:
        case PSR\Log\LogLevel::ALERT:
        case PSR\Log\LogLevel::EMERGENCY:
            $results["danger"][] = $result;
            break;
        default:
            return $results;
    }
});
$smartyValues["successfulChecks"] = array_key_exists("success", $smartyValues["checks"]) ? count($smartyValues["checks"]["success"]) : 0;
$smartyValues["warningChecks"] = array_key_exists("warning", $smartyValues["checks"]) ? count($smartyValues["checks"]["warning"]) : 0;
$smartyValues["dangerChecks"] = array_key_exists("danger", $smartyValues["checks"]) ? count($smartyValues["checks"]["danger"]) : 0;
$smartyValues["keyChecks"] = $keyChecks;
$smartyValues["regularChecks"] = $nonKeyChecks;
$checkPercentages = ["successful" => 0, "warning" => round($smartyValues["warningChecks"] / $smartyValues["totalChecks"] * 100, 0), "danger" => round($smartyValues["dangerChecks"] / $smartyValues["totalChecks"] * 100, 0)];
$checkPercentages["successful"] = 100 - $checkPercentages["warning"] - $checkPercentages["danger"];
$smartyValues["checkPercentages"] = $checkPercentages;
$installedVersion = App::getVersion();
$installedVersionParts = explode(" ", $installedVersion->getCasual(), 2);
if (empty($installedVersionParts[1])) {
    $installedVersionParts[1] = "General Release";
}
$smartyValues["installedVersionNumberParts"] = $installedVersionParts;
$smartyValues["installedVersionNumberCanonical"] = $installedVersion->getCanonical();
$updater = new WHMCS\Installer\Update\Updater();
$smartyValues["installedVersionChangelog"] = $updater->getChangelogUrl();
$smartyValues["installedVersionReleaseNotes"] = $updater->getReleaseNotesUrl();
$aInt->template = "systemhealthandupdates";
$aInt->templatevars = $smartyValues;
$aInt->addInternalJqueryCode("\n\$(document).on('click', '.panel-heading span.clickable', function(e){\n    var \$this = \$(this);\n    if(!\$this.hasClass('panel-collapsed')) {\n        \$this.parents('.panel').find('.panel-body').slideUp();\n        \$this.addClass('panel-collapsed');\n        \$this.find('i').removeClass('glyphicon-chevron-up').addClass('glyphicon-chevron-down');\n    } else {\n        \$this.parents('.panel').find('.panel-body').slideDown();\n        \$this.removeClass('panel-collapsed');\n        \$this.find('i').removeClass('glyphicon-chevron-down').addClass('glyphicon-chevron-up');\n    }\n});\n\$(window).resize(minimiseSuccessPanel);\n\$(document).ready(minimiseSuccessPanel);\n");
$aInt->addHeadJsCode("\nfunction minimiseSuccessPanel() {\n    if (\$(\".health-status-col-danger\").css(\"left\") == \"0px\") {\n        \$(\".panel-health-check-success .panel-heading\").find(\"span\").addClass(\"panel-collapsed\").find(\"i\").removeClass(\"glyphicon-chevron-up\").addClass(\"glyphicon-chevron-down\");\n        \$(\".panel-health-check-success .panel-body\").css(\"display\", \"none\");\n    } else {\n        \$(\".panel-health-check-success .panel-heading\").find(\"span\").removeClass(\"panel-collapsed\").find(\"i\").removeClass(\"glyphicon-chevron-down\").addClass(\"glyphicon-chevron-up\");\n        \$(\".panel-health-check-success .panel-body\").css(\"display\", \"\");\n    }\n}\n");
$aInt->display();

?>