<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

namespace WHMCS\Module\Gateway\EwayV4;

class SecureFieldsJsClient
{
    protected $publicApiKey = "";
    protected $lang = [];
    public function setPublicApiKey($publicApiKey)
    {
        $this->publicApiKey = $publicApiKey;
        return $this;
    }
    public function addLanguageKey($key, $value)
    {
        $this->lang[$key] = addslashes($value);
        return $this;
    }
    public function setLanguage($lang = [])
    {
        $this->lang = $lang;
        return $this;
    }
    public function render()
    {
        return "<script>\n    " . $this->ewaySecureFieldsVariables() . "\n    \n    function eway_hide_cc_fields() {\n        var frm = jQuery('#inputCardNumber').closest('form'),\n            cardInputs = jQuery('#newCardInfo,.cc-details,#existingCardInfo');\n        if (cardInputs.is(':visible')) {\n            cardInputs.slideUp('fast', function() {\n                frm.find('#cctype').removeAttr('name');\n                frm.find('#inputCardCvvExisting').removeAttr('name');\n                frm.find('#inputCardNumber').removeAttr('name');\n                frm.find('#inputCardExpiry').removeAttr('name');\n                frm.find('#inputCardCVV').removeAttr('name');\n                frm.find('#inputCardCvvExisting').removeAttr('name');\n            });\n        }\n    }\n    \n    function eway_remove_cc_fields()\n    {\n        var cardInputs = [\n                'inputCardNumber',\n                'inputCardExpiry',\n            ];\n        jQuery.each(cardInputs, function(index, value) {\n            jQuery('#' + value).closest('div.form-group').remove();\n        });\n        jQuery('#inputCardCvv').removeAttr('name').closest('div.form-group').hide();\n    }\n    \n    function eway_show_cc_fields() {\n        var frm = jQuery('#inputCardNumber').closest('form'),\n            cardInputs = jQuery('#newCardInfo,.cc-details'),\n            showLocal = true;\n    \n        frm.find('#inputCardCvvExisting').attr('name', 'cccvvexisting');\n        frm.find('#inputCardNumber').attr('name', 'ccnumber');\n        frm.find('#inputCardExpiry').attr('name', 'ccexpirydate');\n        frm.find('#inputCardCVV').attr('name', 'cccvv');\n        frm.find('#inputCardCvvExisting').attr('name', 'cccvvexisting');\n        frm.find('#cctype').attr('name', 'cctype');\n    \n        jQuery('#eWAYInputs').hide('fast').remove();\n        \n        if (jQuery('input[name=\"paymentmethod\"]:checked').data('remote-inputs') === 1) {\n            showLocal = false;\n        }\n        var firstVisible = jQuery('input[name=\"ccinfo\"]:visible').first();\n        if (firstVisible.val() === 'new') {\n            if (showLocal) {\n                cardInputs.show();\n            }\n        } else {\n            firstVisible.click();\n        }\n        jQuery('#remoteStorageToken').remove();\n    }\n    \n    " . $this->startEwaySecureFieldsFunction() . "\n    " . $this->secureFieldCallback() . "\n    \n    function eway_secure_fields_html(input) {\n        var frm = input.closest('form')[0],\n            html = '';\n    \n        if (frm.id === 'frmCheckout') {\n            html = '<div id=\"eWAYInputs\" class=\"form-group\">' +\n                '<div class=\"eway-cards-inputs row\">' +\n                '<div class=\"col-md-4 col-sm-6\">' +\n                '<label for=\"secure-field-name\">' + ewayLang.creditCardName + '</label>' +\n                '<div id=\"secure-field-name\" class=\"iframe-input-container\"></div>' +\n                '</div>' +\n                '<div class=\"col-md-3 col-sm-6\">' +\n                '<label for=\"secure-field-card\">' + ewayLang.creditCardInput + '</label>' +\n                '<div id=\"secure-field-card\" class=\"iframe-input-container\"></div>' +\n                '</div><div class=\"col-md-3 col-sm-6\">' +\n                '<label for=\"secure-field-expiry\">' + ewayLang.creditCardExpiry + '</label>' +\n                '<div id=\"secure-field-expiry\" class=\"iframe-input-container\"></div>' +\n                '</div><div class=\"col-md-2 col-sm-6\">' +\n                '<label for=\"secure-field-cvn\">' + ewayLang.creditCardCvc + '</label>' +\n                '<div id=\"secure-field-cvn\" class=\"iframe-input-container\"></div>' +\n                '</div>' +\n                '</div>' + //row\n                '</div>' + //eway-cards-inputs\n                '<div class=\"clearfix\"></div>';\n        } else {\n            html = '<div id=\"eWAYInputs\">' +\n                '<div class=\"form-group cc-billing-address\">' +\n                '<label for=\"secure-field-name\" class=\"col-sm-4 control-label\">' +\n                ewayLang.creditCardName + '</label>' +\n                '<div class=\"col-sm-7\">' +\n                '<div id=\"secure-field-name\" class=\"iframe-input-container\"></div>' +\n                '</div>' +\n                '</div>' +\n                '<div class=\"form-group cc-billing-address\">' +\n                '<label for=\"secure-field-card\" class=\"col-sm-4 control-label\">' +\n                ewayLang.creditCardInput + '</label>' +\n                '<div class=\"col-sm-7\">' +\n                '<div id=\"secure-field-card\" class=\"iframe-input-container\" aria-describedby=\"cc-type\"></div>' +\n                '</div>' + //col-sm-6\n                '<div class=\"col-sm-4\"></div>' +\n                '</div>' + //form-group\n                '<div class=\"form-group cc-billing-address\">' +\n                '<label for=\"secure-field-expiry\" class=\"col-sm-4 control-label\">' +\n                ewayLang.creditCardExpiry + '</label>' +\n                '<div class=\"col-sm-4\">' +\n                '<div id=\"secure-field-expiry\" class=\"iframe-input-container\"></div>' +\n                '</div>' + //col-sm-6\n                '<div class=\"col-sm-6\"></div>' +\n                '</div>' + //form-group\n                '<div class=\"form-group cc-billing-address\">' +\n                '<label for=\"secure-field-cvn\" class=\"col-sm-4 control-label\">' +\n                ewayLang.creditCardCvc + '</label>' +\n                '<div class=\"col-sm-2\">' +\n                '<div id=\"secure-field-cvn\" class=\"iframe-input-container\"></div>' +\n                '</div>' + //col-sm-2\n                '</div>' + //col-sm-4\n                '</div>' + //form-group\n                '</div>' + //row\n                '</div>' + //#eWAYInputs\n                '<div class=\"clearfix\"></div>';\n        }\n        html = html + '<input type=\"hidden\" class=\"form-control\" name=\"remoteStorageToken\"' +\n         ' id=\"remoteStorageToken\">';\n        return html;\n}\n    \n    jQuery(document).ready(function() {\n        var paymentMethod = jQuery('input[name=\"paymentmethod\"]'),\n            frm = jQuery('#frmCheckout'),\n            newCcForm = jQuery('.frm-credit-card-input'),\n            paymentForm = jQuery('#frmPayment'),\n            inputCardNumber = jQuery('#inputCardNumber');\n        inputCardNumber.closest('form').off('submit');\n        if (newCcForm.length) {\n            if (jQuery('input[name=\"type\"]:checked').data('gateway') === 'ewayv4') {\n                eway_hide_cc_fields();\n                newCcForm.find('div.cc-details').after(\n                    eway_secure_fields_html(newCcForm.find('div.cc-details'))\n                ).promise().done(function () {\n                    start_eway_secure_fields();\n                });\n            }\n            \n            jQuery('input[name=\"type\"]').on('ifChecked', function(){\n                if (jQuery(this).data('gateway') === 'ewayv4') {\n                    eway_hide_cc_fields();\n                    newCcForm.find('div.cc-details').after(\n                        eway_secure_fields_html(newCcForm.find('div.cc-details'))\n                    ).promise().done(function () {\n                        start_eway_secure_fields();\n                    });\n                } else {\n                    eway_show_cc_fields();\n                    newCcForm.find('.cc-details').show();\n                }\n            });\n        } else if (paymentForm.length) {\n            var inputCVC = jQuery('#inputCardCvv'),\n                inputCVCGroup = inputCVC.closest('div.form-group'),\n                newOrExisting = jQuery('input[name=\"ccinfo\"]');\n            eway_remove_cc_fields();\n            if (jQuery('input[name=\"ccinfo\"]:checked').val() === 'new') {\n                inputCVCGroup.before(eway_secure_fields_html(inputCVCGroup)).promise()\n                .done(function () {\n                    start_eway_secure_fields();\n                });\n            } else {\n                jQuery('#inputCardCvv').attr('name', 'cccvv').closest('div.form-group').show();\n            }\n            newOrExisting.on('ifChecked', function(){\n                if (jQuery(this).val() === 'new') {\n                    inputCVCGroup.before(eway_secure_fields_html(inputCVCGroup)).promise()\n                    .done(function () {\n                        start_eway_secure_fields();\n                        jQuery('#inputCardCvv').closest('div.form-group').hide();\n                    });\n                } else {\n                    jQuery('#eWAYInputs').hide('fast').remove();\n                    jQuery('#inputCardCvv').attr('name', 'cccvv').closest('div.form-group').show();\n                }\n            });\n        } else if (frm.length) {\n            var newCcInputs = jQuery('#newCardInfo'),\n                selectedPaymentMethod = jQuery('input[name=\"paymentmethod\"]:checked').val(),\n                newOrExisting = jQuery('input[name=\"ccinfo\"]'),\n                newOrExistingChecked = jQuery('input[name=\"ccinfo\"]:checked'),\n                existingCardInfo = jQuery('#existingCardInfo');\n            if (selectedPaymentMethod === 'ewayv4') {\n                eway_hide_cc_fields();\n                if (newOrExistingChecked.val() === 'new') {\n                    newCcInputs.after(eway_secure_fields_html(newCcInputs)).promise()\n                    .done(function () {\n                        start_eway_secure_fields();\n                    });\n                }\n            }\n            \n            paymentMethod.on('ifChecked', function(){\n                selectedPaymentMethod = jQuery(this).val();\n                if (selectedPaymentMethod === 'ewayv4') {\n                    var newOrExistingValue = jQuery('input[name=\"ccinfo\"]:checked').val();\n                    if (newOrExistingValue === 'new') {\n                        eway_hide_cc_fields();\n                        newCcInputs.after(eway_secure_fields_html(newCcInputs)).promise()\n                        .done(function () {\n                            start_eway_secure_fields();\n                        });\n                    } else {\n                        jQuery('#eWAYInputs').hide('fast').remove();\n                        existingCardInfo.show();\n                    }\n                } else {\n                    eway_show_cc_fields();\n                    newCcForm.find('.cc-details').show();\n                }\n            });\n            newOrExisting.on('ifChecked', function() {\n                selectedPaymentMethod = jQuery('input[name=\"paymentmethod\"]:checked').val();\n                if (selectedPaymentMethod !== 'ewayv4') {\n                    return;\n                }\n                eway_hide_cc_fields();\n                if (jQuery(this).val() === 'new') {\n                    newCcInputs.after(eway_secure_fields_html(newCcInputs)).promise()\n                        .done(function () {\n                            start_eway_secure_fields();\n                        });\n                } else {\n                    jQuery('#eWAYInputs').hide('fast').remove();\n                    existingCardInfo.show();\n                }\n            });\n        }\n    });\n</script>";
    }
    public function renderAdmin()
    {
        return "<script>\n    " . $this->startEwaySecureFieldsFunction() . "\n    " . $this->ewaySecureFieldsVariables() . "\n    " . $this->secureFieldCallback() . "\n    \n    jQuery(document).ready(function() {\n        var adminCreditCard = jQuery('#frmCreditCardDetails'),\n            inputCardNumber = jQuery('#inputCardNumber');\n        inputCardNumber.closest('form').off('submit');\n        if (adminCreditCard.length) {\n            adminCreditCard.find('#inputCardNumber')\n                .closest('div.row')\n                .before(\n                    '<div class=\"row\"><div class=\"col-sm-12 form-group\">' +\n                    '<label for=\"secure-field-name\">' + ewayLang.creditCardName + '</label>' +\n                    '<div class=\"input-group\">' +\n                    '<div id=\"secure-field-name\" class=\"iframe-input-container\"></div>' +\n                    '</div></div></div>'\n                );\n            adminCreditCard.find('#inputCardNumber')\n                .closest('div')\n                .html('<div id=\"secure-field-card\" class=\"iframe-input-container\"></div>');\n            adminCreditCard.find('#inputCardExpiry')\n                .closest('.col-sm-6')\n                .attr('class', 'col-sm-12');\n            adminCreditCard.find('#inputCardExpiry')\n                .closest('div')\n                .html('<div id=\"secure-field-expiry\" class=\"iframe-input-container\"></div>');\n            adminCreditCard.find('#cardcvv')\n                .closest('div')\n                .html('<div id=\"secure-field-cvn\" class=\"iframe-input-container\"></div>');\n            adminCreditCard.append(\n                '<input type=\"hidden\" name=\"remoteStorageToken\"' +\n                    ' id=\"remoteStorageToken\" class=\"form-control\">'\n            );\n            \n            start_eway_secure_fields();\n        }\n    });\n</script>";
    }
    protected function startEwaySecureFieldsFunction()
    {
        return "function start_eway_secure_fields() {\n    if (\n        jQuery('#secure-field-cvn').length > 0\n    ) {\n        if (startTimer) {\n            clearTimeout(startTimer);\n        }\n        eWAY.setupSecureField(nameFieldConfig, secureFieldCallback);\n        eWAY.setupSecureField(cardFieldConfig, secureFieldCallback);\n        eWAY.setupSecureField(expiryFieldConfig, secureFieldCallback);\n        eWAY.setupSecureField(cvnFieldConfig, secureFieldCallback);\n        return;\n    }\n    startTimer = setTimeout(start_eway_secure_fields, 250);\n}";
    }
    protected function ewaySecureFieldsVariables()
    {
        $lang = "";
        foreach ($this->lang as $key => $value) {
            $lang .= $key . ": '" . $value . "',";
        }
        if ($lang) {
            $lang = substr($lang, 0, -1);
        }
        return "var publicApiKey = \"" . $this->publicApiKey . "\",\n    nameFieldConfig = {\n        publicApiKey: publicApiKey,\n        fieldDivId: \"secure-field-name\",\n        fieldType: \"name\",\n        styleTemplateId: 'remoteStorageToken'\n    },\n    cardFieldConfig = {\n        publicApiKey: publicApiKey,\n        fieldDivId: \"secure-field-card\",\n        fieldType: \"card\",\n        styleTemplateId: 'remoteStorageToken'\n    },\n    expiryFieldConfig = {\n        publicApiKey: publicApiKey,\n        fieldDivId: \"secure-field-expiry\",\n        fieldType: \"expiry\",\n        styleTemplateId: 'remoteStorageToken'\n    },\n    cvnFieldConfig = {\n        publicApiKey: publicApiKey,\n        fieldDivId: \"secure-field-cvn\",\n        fieldType: \"cvn\",\n        styleTemplateId: 'remoteStorageToken'\n    },\n    ewayLang = {\n        " . $lang . "\n    },\n    startTimer = null;";
    }
    protected function secureFieldCallback()
    {
        return "function secureFieldCallback(event) {\n    if (!event.fieldValid) {\n        jQuery('#secure-field-name').closest('form')\n            .find('button[type=\"submit\"],input[type=\"submit\"]')\n            .prop('disabled', true)\n            .addClass('disabled')\n            .find('span').toggleClass('hidden');\n        \n        var displayError = jQuery('.gateway-errors,.assisted-cc-input-feedback').first();\n        displayError.html(event.errors);\n        if (displayError.hasClass('hidden')) {\n            displayError.removeClass('hidden').show();\n        }\n        scrollToGatewayInputError();\n        \n    } else {\n        // set the hidden Secure Field Code field\n        var s = document.getElementById(\"remoteStorageToken\");\n        s.value = event.secureFieldCode;\n        var button = jQuery('#secure-field-name')\n                .closest('form')\n                .find('button[type=\"submit\"],input[type=\"submit\"]');\n        if (button.hasClass('disabled')) {\n            button.prop('disabled', false)\n                .removeClass('disabled')\n                .find('span').toggleClass('hidden');\n        }\n    }\n}";
    }
}

?>