<?php


namespace Addons\DNS\Helper;


class Common
{
  public static function dns_data($args) {

        $connected_dns = null;
        $availableDns = [];
        $activeAddon = \App\Addon::where('install_dir','dns')->where('status','active')->first();
        if(!is_null($activeAddon)) {
            $connected_dns =\Addons\DNS\Entities\DNSProvidersAttached::where('domain_id',$args['id'])->first();
            $availableDns = \Addons\DNS\Entities\AddonDNS::select('addons_dns.*','p.status as active_status')
                ->where('user_id','=',auth()->user()->id)
                ->where(function($query){
                    $query->where('p.status','=',1);
                    $query->orWhere('p.status','=',null);
                })->leftJoin('addons_dns_providers_statuses as p','p.class','=','addons_dns.class_name')
                ->get();
        }
        return ['dns' => $connected_dns,'dns_list' => $availableDns];

    }
    public static function get_user_settings() {
        $authUser=auth()->user();
        if (isClient($authUser)) {
            $user_settings = \App\user_settings::where('user_id', 2)->get()->first();
        } else {
            $user_settings = \App\user_settings::where('user_id', $authUser->id)->get()->first();
        }

        return $user_settings;
    }

     public static function checkLicense($licensekey , $localkey = '') {
        
        $whmcsurl = 'https://marketplace.arfan.dev.jt.hostingshouse.com/verifyLicense';
        $licensing_secret_key = '4be4ce9abd6c8c8a97d372bf04cbaa94';
        // The number of days to wait between performing remote license checks
        $localkeydays = 5;
        // The number of days to allow failover for after local key expiry
        $allowcheckfaildays = 2;
        // -----------------------------------
        // -- Do not edit below this line --
        // -----------------------------------
        $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
        $checkdate = date("Ymd");
        $domain = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : env("DOMAIN_URL");
        $domain = str_replace("http://" , "" , $domain );
        $domain = str_replace("https://" , "" , $domain );
        
        $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
        $dirpath = dirname(dirname(__FILE__));
        $verifyfilepath = 'modules/servers/licensing/verify.php';
        $localkeyvalid = false;
       
        if ($localkey) {
            $localkey = str_replace("\n", '', $localkey); // Remove the line breaks
            $localkey = str_replace(" ", '', $localkey); // Remove the line breaks
            // $localkey = preg_replace( "/\r|\n/", "", $localkey); // Remove the line breaks
            $localdata = substr($localkey, 0, strlen($localkey) - 32); // Extract License Data
            $md5hash = substr($localkey, strlen($localkey) - 32); // Extract MD5 Hash
           
           
            if ($md5hash == md5($localdata . $licensing_secret_key)) {
                $localdata = strrev($localdata); // Reverse the string
                $md5hash = substr($localdata, 0, 32); // Extract MD5 Hash
                $localdata = substr($localdata, 32); // Extract License Data
                $localdata = base64_decode($localdata);
                $localkeyresults = unserialize($localdata);
                $originalcheckdate = $localkeyresults['checkdate'];
                if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                    $localexpiry = date("Ymd", mktime(0, 0, 0, date("m"), date("d") - $localkeydays, date("Y")));
                    if ($originalcheckdate > $localexpiry) {
                        $localkeyvalid = true;
                        $results = $localkeyresults;
                        $results['status'] = "Active";
                        if(!empty($results['validdomain'])) { 
                            $validdomains = explode(',', $results['validdomain']);
                            if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                                $localkeyvalid = false;
                                $localkeyresults['status'] = "Invalid";
                                $localkeyresults['msg'] = "Your addon is already bind to another domain.";
                                $results = array();
                            }
                        }
                    }
                }
            }

        }

      
        $originalcheckdate = "";
        if (!$localkeyvalid) {
            $postfields = array(
                'purchase_code' => $licensekey,
                'domain' => $domain,
                'ip' => $usersip
            );
            if ($check_token) {
                $postfields['check_token'] = $check_token;
            }
            $query_string = '';
            foreach ($postfields as $k => $v) {
                $query_string .= $k . '=' . urlencode($v) . '&';
            }
            if (function_exists('curl_exec')) {
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $whmcsurl);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $data = curl_exec($ch);
                $data = json_decode($data , true);
                curl_close($ch);
            } else {
                $fp = fsockopen($whmcsurl, 80, $errno, $errstr, 5);
                if ($fp) {
                    $newlinefeed = "\r\n";
                    $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                    $header .= "Host: " . $whmcsurl . $newlinefeed;
                    $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                    $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                    $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                    $header .= $query_string;
                    $data = '';
                    @stream_set_timeout($fp, 20);
                    @fputs($fp, $header);
                    $status = @socket_get_status($fp);
                    while (! @feof($fp) && $status) {
                        $data .= @fgets($fp, 1024);
                        $status = @socket_get_status($fp);
                    }
                    @fclose($fp);
                }
            }
            $results = array();
            
           if($data["status"] == "Invalid") { 
                $results["status"] = "Invalid";
                $results["message"] = $data["msg"];
           }

         
            if ($data['status'] == "Active") {
                $results['status'] = "Active";
                $results['checkdate'] = $checkdate;
                $results['validdomain'] = $data["installed_domain"];
                $results['validip'] = $usersip;
                $data_encoded = serialize($results);
                $data_encoded = base64_encode($data_encoded);
                $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
                $data_encoded = strrev($data_encoded);
                $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
                // $data_encoded = wordwrap($data_encoded, 80, "\n", true);
                $results['localkey'] = $data_encoded;
            }
            $results['remotecheck'] = true;
        }  
       
        return $results;
    }

     public static function verify_license() {
        try {
            $configFile = addonSettingDir('DNS') . DIRECTORY_SEPARATOR . 'config.php'; // addonSettingDir() return path upto addon "Setting" directory
            if (!file_exists($configFile)) 
            throw new \Exception("Config file $configFile not exists", 1);
            include $configFile;

            $localKey=isset($setting['local_key']) ? $setting['local_key']:'';   
            $licenseKey=isset($setting['license_key']) ? $setting['license_key']:'';
             if(empty($licenseKey))
                throw new \Exception(trans('addons.message.license_key_not_found'), 1);
            $license_result = Common::checkLicense($licenseKey, $localKey);
                if($license_result['status'] !="Active")
                throw new \Exception($license_result['status']." License key.".($license_result['message'] ?? ''), 1);
            $msg="success";
        } catch (\Exception $e) {
             $msg= $e->getMessage();
            
        }
        return $msg;
        
    }
}