<?php
namespace Addons\DNS\Modules;
/**
 * Class AWS
 * @package Addons\DNS\Modules
 */
class AWS
{

    /**
     * @return array
     */
    function AWS_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "AWS",
            "description" => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.",
            "logo" => "images/route53.png", // Resources/assets/images
            "help_url"=>"https://docs.aws.amazon.com/powershell/latest/userguide/pstools-appendix-sign-up.html"
                ],
            'form' => [
                
                 [
                    "label" => trans('dns::app.aws.access_key_id'),
                    "name" => "aws_access_key_id",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px, rem, % etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  trans('dns::app.aws.access_key_id_help'), # Description of the Field
                    "default" => "" # Default value of the Field
                ],
                [
                    "label" => trans('dns::app.aws.secret_access_key'),
                    "name" => "aws_secret_access_key",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px, rem, % etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  trans('dns::app.aws.secret_access_key_help'), # Description of the Field
                    "default" => "" # Default value of the Field
                ],
                

                
                
            ]
        ];
        return $configArray;
    }


    public function AWS_Update($params)
    {
       try{
            $params['zone_by_name']=true;
            $client = new \GuzzleHttp\Client();
            $response = $client->request('GET', url('Addons/DNS/aws/index.php'), ['query' => $params])->getBody();
            $response = json_decode($response,true);
             if($response['success']==1){
               return ['success' => true ,'message' =>$response['data']]; 
            }else{
                throw new \Exception($response['data'], 1);
            }
            
        } catch (\Exception $e) {
            return ['success' => false ,'message' => $e->getMessage()]; 
        }
             
   
   }
    
   

  

    public function AWS_FetchZones($params)
    {
        try{
            $params['all_zones']=true;
           // Create a client with a base URI
            $client = new \GuzzleHttp\Client();
            $response = $client->request('GET', url('Addons/DNS/aws/index.php'), ['query' => $params])->getBody();
            $response = json_decode($response,true);
            $zones=[];
            if($response['success']==1){
                foreach($response['data'] as $item){
                    $zones[]=$item['Name'];
                }
            }else{
                throw new \Exception($response['data'], 1);
            }
            return ['success' => true ,'options' =>$zones];
            
        } catch (\Exception $e) {
            return ['success' => false ,'options' => [],'message' => $e->getMessage()]; 
        }
       

        
    }

}