<?php
namespace Addons\DNS\Modules;

/**
 * Class DNS Made Easy
 * @package Addons\DNS\Modules
 */
class GoDaddy
{
    /**
     *
     */
    static $sandbox_url    = 'https://api.ote-godaddy.com/';
    static $production_url = 'https://api.godaddy.com/';
    private $params         = [];
    /**
     * @return array
     */
    function GoDaddy_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "GoDaddy",
            "description" => "The GoDaddy API allows developers to interact with the GoDaddy system in the same way we do. The API can be used by anyone who wants to manage their domains and account or create their own experience for registering, purchasing, and managing domains.",
            "logo" => "images/GoDaddy.png",
            "help_url"=>"https://pk.godaddy.com/help/set-up-my-api-reseller-account-40137"
                ],
            'form' => [
                [
                    "label" => "Envoirnment",
                    "name" => "envoirnment",
                    "type" => "radio", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "envoirnment", # Defines the Field class
                    "options" => ['OTE','Production'], # List Options
                    "description" =>  "OTE or Production",
                    "default" => "OTE"
                ],
                [
                    "label" => "API Key",
                    "name" => "api_key",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  "You will need an API Key and Secret to authenticate and authorize your requests.",
                    "default" => ""
                ],
                 [
                    "label" => "Secret Key",
                    "name" => "secret_key",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  "You will need an API Key and Secret to authenticate and authorize your requests. ",
                    "default" => ""
                ]
            ]
        ];
        return $configArray;
    }


    public function GoDaddy_Update($params)
    {

        $this->params=$params;
         $response = $this->apiCall('v1/domains'); // Fetching all zones
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
       
        $domain = '';
        foreach ($data as $key => $item) {
            if($item['domain'] ==$params['domain']){
                $domain=$item['domain'];
                break;
            }
        }

        if($domain == '')
           return ['success' => false,'message' => 'Zone dosn\'t exists'];

          // Creating a zone record 
        $data=[[
            "name" => $params['host'],
            "type" => $params['type'],
            "data" => $params['value'],
            "ttl" => 600
        ]];
        $response = $this->apiCall("v1/domains/{$domain}/records/{$params['type']}/{$params['host']}",$data,'PUT'); // Creating zone record
        $data=json_decode($response,true);
         if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
       if(isset($data['fields'])){
        $message="";
        foreach ($data['fields'] as $key => $value) {
           $message.="{$value['path']} {$value['message']}\n";
        }
        return ['success' => false ,'message' =>$message];
       }
   
        return ['success' => true ,'message' =>'Record have been added successfully'];
   }
    
  

   private function apiCall ( $url,$data=[],$method="GET") {

        $api_key=$this->params['auth_data']['api_key'];
        $secret_key=$this->params['auth_data']['secret_key'];
        $envoirnment=$this->params['auth_data']['envoirnment'];

        // API access url based on envoirnment
        if($envoirnment=="OTE"){
           $api_url = self::$sandbox_url.$url;
        }else{
           $api_url = self::$production_url.$url;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type:application/json',
            'Accept: application/json',
            "Authorization: sso-key $api_key:$secret_key",
        ]);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_URL,  $api_url);

          // Params to send with POST method
         if(!empty($data) && ($method=="POST" || $method=="PUT")){
            $body = json_encode($data);
            // set body
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
         }
         // Sending request
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function GoDaddy_FetchZones($params)
    {
       
        $this->params=$params;
        $response = $this->apiCall('v1/domains'); // Fetching all zones
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
        $zones = [];
        foreach ($data as $key => $item) {
            $zones[]= $item['domain'];
        }

        return ['success' => true ,'options' =>$zones];
    }

}