<?php
namespace Addons\DNS\Modules;
require_once base_path('Addons/DNS/vendor/autoload.php');
use Google\Auth\ApplicationDefaultCredentials;
use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Exception\RequestException;
/**
 * Class DNS Made Easy
 * @package Addons\DNS\Modules
 */
class GoogleCloudDNS
{
    /**
     *
     */
    private $params  = [];
    /**
     * @return array
     */
    function GoogleCloudDNS_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "Google Cloud DNS",
            "description" => "Cloud DNS can scale to large numbers of DNS zones and records. You can reliably create and update millions of DNS records. Our name servers automatically scale to handle query volume.",
            "logo" => "images/GoogleCloudDNS.png"
                ],
            'form' => [
                [
                    "label"       => "Project ID",
                    "name"        => "project_id",
                    "type"        => "text", # Type of the Field
                    "width"       => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class"       => "form-control", # Defines the Field class
                    "description" =>  "Project ID from <a href='https://console.cloud.google.com/'>https://console.cloud.google.com/</a>",
                    "default"     => ""
                ],
                 [
                    "label"       => "Service account key (.json format)",
                    "name"        => "jsonKey",
                    "type"        => "textarea", # Type of the Field
                    "width"       => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class"       => "form-control", # Defines the Field class
                    "description" => "Follow steps <a target='_blank' href='https://cloud.google.com/docs/authentication/production#cloud-console'>here</a> to create service account key. After downloading key file, paste the content inside that file here.",
                    "default"     => ""
                ]
            ]
        ];
        return $configArray;
    }


    public function GoogleCloudDNS_Update($params)
    {

       $this->params=$params;
        try{
            $response = $this->apiCall('managedZones'); // Fetching all zones
        }catch (RequestException $e) {
                return ['success' => false ,'message' =>$e->getMessage()];
        }

        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
       
       // Finding Matching Item
        $zone_id = '';
        foreach ($data['managedZones'] as $key => $item) {
            if(rtrim($item['dnsName'],'.') ==$params['domain']){
                $zone_id=$item['id'];
                break;
            }
        }

        if($zone_id == '')
           return ['success' => false,'message' => 'Zone dosn\'t exists'];
       
            $value=$params['value'];
              if($params['type']== "TXT" && strlen($value) > 255 ){
                $string = '';
                $parts = str_split($value, 255);
                    foreach($parts as $part){
                       $string.='"'.$part.'"';
                    }
                $value=$string;
                }
                  // Deleting existing zone record 
            $data=[ 
                "deletions"=>[
                "name" => $params['host'].".".$params['domain'].".",
                 "rrdatas" => $params['type']== "TXT" ? [''.$value.'']:[$value."."],
                "type" => $params['type'],
                 "ttl" => 600
            ]
            ];
        
        
       try{
            $response = $this->apiCall("managedZones/$zone_id/changes",$data,'POST'); // Fetching all records
        }catch (RequestException $e) {
             $message="";
           $error = $e->getResponse()->getBody();
           $error = json_decode( $error,true);
           if(isset($error['error'])){
               foreach($error['error']['errors'] as $error){
                   $message.=$error['message'];
               }
           }
       
        
                return ['success' => false ,'message' => $message];
        }
          // Creating a zone record 
        $data=[ 
        "additions"=>[
            "name" => $params['host'].".".$params['domain'].".",
            "type" => $params['type'],
            "rrdatas" => $params['type']== "TXT" ? [''.$value.'']:[$value."."],
            "ttl" => 600
        ]
        ];
        
        
       try{
            $response = $this->apiCall("managedZones/$zone_id/changes",$data,'POST'); // Fetching all records
        }catch (RequestException $e) {
        //   $message="";
        //   $error = $e->getResponse()->getBody();
        //   $error = json_decode( $error,true);
        //   if(isset($error['error'])){
        //       foreach($error['error']['errors'] as $error){
        //           $message.=$error['message'];
        //       }
        //   }
       
        
        //         return ['success' => false ,'message' => $message];
        }

        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
       
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
   
        return ['success' => true ,'message' =>'Record have been added successfully'];
   }
    
  

   private function apiCall ( $url,$data=[],$method="GET") {

        $jsonKey=$this->params['auth_data']['jsonKey'];
        $project_id=$this->params['auth_data']['project_id'];

        // define the scopes for your API call
        $scopes = ['https://www.googleapis.com/auth/cloud-platform'];
        // create middleware
        $middleware = ApplicationDefaultCredentials::getMiddleware($scopes,null,null,null,null,$jsonKey);
        $stack = HandlerStack::create();
        $stack->push($middleware);

        // create the HTTP client
        $client = new Client([
          'handler' => $stack,
          'debug' =>false,
          'verify' => false,
          'base_uri' => 'https://dns.googleapis.com/dns/v1/projects/',
          'auth' => 'google_auth',  // authorize all requests
          'headers' => ['Accept'     => 'application/json' ]
        ]);
        // make the request
        if($method=="GET")
        $response = $client->get("$project_id/$url");
        else
        $response = $client->post("$project_id/$url",[
            'json' => $data
        ]);
        $response = $response->getBody();
         return $response;
    }

    public function GoogleCloudDNS_FetchZones($params)
    {
       
        $this->params=$params;
        try{
            $response = $this->apiCall('managedZones'); // Fetching all zones
        }catch (RequestException $e) {
                return ['success' => false ,'message' =>$e->getMessage()];
        }

        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
        $zones = [];
        foreach ($data['managedZones'] as $key => $item) {
            $zones[]= rtrim($item['dnsName'],'.');
        }

        return ['success' => true ,'options' =>$zones];
    }

}