<?php
namespace Addons\DNS\Modules;

/**
 * Class Hetzner
 * @package Addons\DNS\Modules
 */
class Hetzner
{
    /**
     *
     */
    const URL = 'https://dns.hetzner.com/api/v1';

    /**
     * @return array
     */
    function Hetzner_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "Hetzner",
            "description" => "Hetzner Cloud Hosting",
            "logo" => "images/hetzner.jpg",
            "help_url"=>"https://docs.hetzner.com/dns-console/dns/general/api-access-token/"
                ],
            'form' => [
                [
                    "label" => "API Access Token",
                    "name" => "api_access_token",
                    "type" => "text", # Password Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  "To access the Hetzner DNS API",
                    "default" => ""
                ]
            ]
        ];
        return $configArray;
    }


    public function Hetzner_Update($params)
    {

        // Fetching all zones
        $api_url = self::URL.'/zones'; 
        $token=$params['auth_data']['api_access_token'];
        $data=[];
        $response = $this->apiCall($api_url,$token, $data);
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
        $zone_id = '';
        foreach ($data['zones'] as $key => $item) {
            if($item['name'] ==$params['domain']){
                $zone_id=$item['id'];
            }
        }
        if($zone_id == '')
           return ['success' => false,'message' => 'Zone dosn\'t exists'];

           // Getting zone records   
        $api_url = self::URL.'/records'; // Fetching all records
        $data=['zone_id'=>$zone_id];
        $response = $this->apiCall($api_url,$token, $data);
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
        if(!empty($data['records'])){
            foreach ($data['records'] as $record) {
            if($record['type']==$params['type'] && $record['name']==($params['host'].".".$params['domain'])){
                $record_id=$record['id'];
                  // Deleting zone record   
                $api_url = self::URL."/records/$record_id"; // Fetching all records
                $data=['RecordID'=>$record_id];
                $response = $this->apiCall($api_url,$token, $data,"DELETE");
                if(!isJson($response))
                    return ['success' => false ,'message' =>$response];
                $data=json_decode($response,true);
                if(isset($data['message']))
                    return ['success' => false ,'message' =>$data['message']];
            }
          }
        }
       
          // Creating a zone record 
        $data=[
            "zone_id" => $zone_id,
            "type" => $params['type'],
            "name" => $params['host'].".".$params['domain'],
            "value" => $params['value'],
            "ttl" => 0
        ];
         $api_url = self::URL.'/records'; // Fetching all records
        $response = $this->apiCall($api_url,$token, $data,'POST');
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
         if(isset($data['error']))
            return ['success' => false ,'message' =>$data['error']['message']];

        return ['success' => true ,'message' =>'Record have been added successfully'];
   }
    
  

   private function apiCall ( $api_url,$token, $data,$method="GET") {
    
        if(!empty($data) && $method=="GET"){
             $params='?';
            foreach ($data as $key => $value)
                $params .= $key."=".$value."&";
            $api_url .= substr($params,0,-1);  
        }
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
          "Content-Type: application/json",
          "Auth-API-Token: $token",
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_URL,  $api_url);
         if(!empty($data) && $method=="POST"){
            $body = json_encode($data);
            // set body
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
         }
        $response = curl_exec($ch);
        // stop if fails
        if (!$response) {
            $data= 'Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch).' HTTP Status Code: ' . curl_getinfo($ch, CURLINFO_HTTP_CODE);
        }else{
            $data=$response;
        }
        curl_close($ch);
        return $data;
    }

    public function Hetzner_FetchZones($params)
    {
       
        $api_url = self::URL.'/zones'; // Fetching all zones
        $token=$params['auth_data']['api_access_token'];
        $data=[];
        $response = $this->apiCall($api_url,$token, $data);
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
        $zones = [];
        foreach ($data['zones'] as $key => $item) {
            $zones[]= $item['name'];
        }

        return ['success' => true ,'options' =>$zones];
    }

}