<?php
namespace Addons\DNS\Modules;

/**
 * Class cloudns
 * @package Addons\DNS\Modules
 */
class cloudns
{
    /**
     *
     */
    const URL = 'https://api.cloudns.net/';
    public $priority = 10;

    /**
     * @return array
     */
    function cloudns_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "CloudDns",
            "description" => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.",
            "logo" => "images/clouddns.jpg",
            "help_url"=>"https://www.cloudns.net/wiki/article/42/"
                ],
            'form' => [
                [
                    "label" => trans('dns::app.create_module.field.sub_auth_id'),
                    "name" => "auth-id-value",
                    "type" => "text", # Password Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  trans('dns::app.create_module.field.sub_auth_id_help'),
                    "default" => "",
                    "insertTop" =>[[ 
                    "label" =>  "Auth ID",  # Label of the field
                    "name" =>   "auth_type",  # Name of the input field
                    "type" =>   "radio", # Type of the field
                    "options" => ['sub-auth-id','auth-id'], # List Options
                    "width" => "", # Defines the Field Width in px, rem, % etc. Leave empty if you don't want
                    "class" => "auth_type", # Defines the Field class
                    "description" => "",
                    "default" => "sub-auth-id",
                   ]]
                ],
                [
                    "label" =>  trans('dns::app.create_module.field.auth_password'),
                    "name" => "auth-password",
                    "type" => "password", # Password Field
                    "width" => "",# Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" => trans('dns::app.create_module.field.auth_password_help'),
                    "default" => "",
                ]
            ]
        ];
        return $configArray;
    }


    public function cloudns_Update($params)
    {
        // Authenticate Request
       $authenticated=self::cloudns_authenticate($params);
       if(!$authenticated)
           return ['success' => false,'message' => trans('dns::app.modal.invalid_credentials')];
       $records=self::cloudns_fetchRecordsBy($params); // Get existing records
       if(!is_array($records))
           return ['success' => false,'message' => $records];
       if($records && count($records) > 0){
            foreach ($records as $record) {
                if (isset($record['id'])) {
                    $params['record_id'] =  $record['id'];
                    $status = self::cloudns_deleteRecord($params); // Delete existing records
                    if (!$status['success']) {
                        $message = $status['message'];
                        break;
                        return ['success' => false,'message' => $message];
                    }
                }
            }
        
        }

        $response = self::cloudns_addRecord($params); // Add New Record
        return $response;
   }
    
    public function cloudns_fetchRecordsBy($params)
    {
        $domain = $params['domain'];
        $host   = $params['host'];
        $type   = $params['type'];

        $records = [];
        $url = self::URL.'dns/records.json';
        $credentials = $params['auth_data'];
         $data=self::beautiFy($credentials);
        $data .= "&domain-name=$domain";
        if(!is_null($host))
            $data .= "&host=$host";
        if(!is_null($type))
            $data .= "&type=$type";
        $response = requestCurl($url . $data);
        if (isJson($response)) {
            $recordList = json_decode($response,true);
            if(isset($recordList['status']) && $recordList['status']=="Failed")
            return $recordList['statusDescription'];
            foreach ($recordList as $record)
                $records[] = ['id' => $record['id'],'zone_id' => isset($record['zone_id']) ? $record['zone_id']: null];
        }
        return $records;
    }

    public function cloudns_deleteRecord($params)
    {
        $id = $params['record_id'];
        $domain = $params['domain'];
        $url = self::URL.'dns/delete-record.json';
        $credentials = $params['auth_data'];
         $data=self::beautiFy($credentials);
        $data .= "&domain-name=$domain&record-id=$id";
        $success = false;
        $response = requestCurl($url . $data);
        if (isJson($response)) {
            $records = json_decode($response,true);
            $success =  $records['status']=='Success' ? true : false;
            $response = $records['statusDescription'];
        }
        return ['success' => $success,'message' => $response];
    }

    public function cloudns_addRecord($params,$ttl = 3600)
    {
        $domain = $params['domain'];
        $host = $params['host'];
        $value = $params['value'];
        $type = $params['type'];

        $url = self::URL.'dns/add-record.json';
        $credentials = $params['auth_data'];
         $data=self::beautiFy($credentials);
        $value = str_replace("+" , "%2B" , $value);
        $data .= "&domain-name=$domain&record-type=$type&host=$host&record=$value&ttl=$ttl";
        if($type=='MX')
            $data .= "&priority=$this->priority";
        $success = false;
        $response = requestCurl($url . $data);
        if (isJson($response)) {
            $record = json_decode($response,true);
            $success =  $record['status']=='Success' ? true : false;
            $response = $record['statusDescription'];
        }
        return ['success' => $success,'message' => $response];
    }


    public function cloudns_authenticate($params)
    {
        $authenticated = true;
        $url = self::URL.'dns/login.json';
        $credentials = $params['auth_data'];
        $data=self::beautiFy($credentials);
        $response = requestCurl($url . $data);
        if(!$response)
            $authenticated = false;
        $response = json_decode($response);
        if($response->status == 'Failed')
            $authenticated = false;
        return $authenticated;
    }

    private function apiCall ($url, $data) {
        $url_ = self::URL."{$url}";
        $url_ = $url_.$data;
        $init = curl_init();
        curl_setopt($init, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($init, CURLOPT_URL, $url_);
        curl_setopt($init, CURLOPT_POST, true);
        curl_setopt($init, CURLOPT_POSTFIELDS, $data);
        curl_setopt($init, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($init, CURLOPT_SSL_VERIFYPEER, 0);
        // curl_setopt($init, CURLOPT_USERAGENT, 'cloudns_api_script/0.1 (+https://github.com/ClouDNS/cloudns-api-bulk-updates/tree/master/bulk-records-update)');
        $content = curl_exec($init);
        curl_close($init);
        return json_decode($content, true);
    }

    public function cloudns_FetchZones($params)
    {
        $authenticated=self::cloudns_authenticate($params);
       if(!$authenticated)
           return ['success' => false,'message' => trans('dns::app.modal.invalid_credentials')];
        $url = self::URL.'dns/list-zones.json';
        $credentials = $params['auth_data'];
        $data=self::beautiFy($credentials);
        $options = [];
        $rows_per_page = 10; // 100 is the maximum
        $pages = $this->apiCall('dns/get-pages-count.json', "$data&rows-per-page={$rows_per_page}");
        for ($i=1; $i<=$pages; $i++) {

            $params = $data. '&page=' . $i . '&rows-per-page=' . $rows_per_page;
            $response = requestCurl($url . $params);
            if (isJson($response)) {
                $zoneList = json_decode($response,true);
                foreach ($zoneList as $item) {
                    try {
                        $options[]= $item['name'];
                    }
                    catch (\Exception $e)
                    {
                        $status = $e->getMessage();
                        break;
                    }
                }
            }
        }

        return ['success' => true ,'options' => $options];
    }
     public function beautiFy($credentials){
         $data='?';
        foreach ($credentials as $key => $credential)
            if($key=="auth_type")
            $data .= $credential."=".$credentials['auth-id-value']."&";
            else
            $data .= $key."=".$credential."&";
        return $data = substr($data,0,-1);
     }

}