@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
    <link rel="stylesheet" type="text/css" href="{{ url('Addons/DNS/Resources/assets/css/create-dns.css') }}">
@endsection

@section('page_scripts')
    <script>
        var form_error="{{trans('common.message.form_error')}}";
    </script>
    <script src="{{ url('/') }}/themes/default/js/select2.full.min.js" type="text/javascript"></script>
    <script src="{{ url('/') }}/themes/default/js/select2.js" type="text/javascript"></script>
    <script src="{{ asset('themes/default/js/includes/form-validator.js') }}" type="text/javascript"></script>
    <script src="{{ asset('themes/default/js/jquery.validate.js') }}" type="text/javascript"></script>
    <script>
        $('.m-select2').select2();
        $(document).ready(function () {
            $('.sb').click(function (e) {
                page_action = $(this).data('form');
                id = $('#id').val();
                formId = '#dns';
                route = '{{route('dnsModuleAdd')}}';
                method = 'POST';
                if(id>0)
                {
                    route = '#';
                    method = 'PUT';
                    route = '{{route('dnsModuleUpdate',isset($dns)?$dns->id:'')}}';
                }

                processFrom(method,route,formId,e,'btn','success','error');
            }) ;
        });
        function validateCredentials() {
            $.ajax({
                type    : "POST",
                url     : "{{'dnsModuleAdd'}}",
                data    : $('#cloudFlare').serialize(),
                dataType:"json",
                beforeSend : function()
                {
                    $(".blockUI").show();
                },
                success: function(result) {
                    $(".blockUI").hide();
                    if(result.status)
                        Command: toastr["success"] ("{{trans('app.dns.valid.credentials')}}");
                    else
                        Command: toastr["error"] ("{{trans('app.dns.invalid.credentials')}}");

                }
            });
        }
        $('.popovers').popover({'trigger':'click focus hover'});
    </script>
@endsection

@section(decide_content())
    <!-- For PHP validations errors-->
    <div id="error" class="alert alert-danger" style="display: none">

    </div>

    <!-- will be used to show any messages -->

    <div id="success" class="alert alert-success" style="display: none">

    </div>

    <!-- will be used to show any messages -->
    <div id="msg" class="display-hide">
        <button class="close" data-close="alert"></button>
        <span id='msg-text'><span>
    </div>
    <div class="col-md-12">
        <!-- BEGIN FORM-->
        @if(isset($config['config']))
        <form action=""  id="dns" class="kt-form kt-form--label-right" novalidate="novalidate">
            <input type="hidden" name="_token" id="c_token" value="{{ csrf_token() }}">
            <input type="hidden" id="id" value="{{isset($dns) ? $dns->id:'0'}}">
            <input type="hidden" id="class_name" name="class_name" value="{{isset($className) ? $className : '' }}" class="form-control" />
            <div class="row">
                <div class="kt-portlet kt-portlet--height-fluid">
                    <div class="kt-portlet__head title-flex">
                        <div class="kt-portlet__head-label">
                        @if(Request::segment(5)=='edit')
                        <h3 class="kt-portlet__head-title">{{trans('dns::app.edit_module.add').$config['config']['name']}}</h3>
                        @else
                        <h3 class="kt-portlet__head-title">{{trans('dns::app.create_module.add').$config['config']['name']}}</h3>
                        @endif
                         @if(!empty($config['config']['help_url']))
                        <div class="help_url">
                            <a title=" {{trans('dns::app.help')}}" target="_blank" href="{{$config['config']['help_url']}}">
                                <i class="la la-question-circle"></i>
                            </a>
                        </div>
                        @endif
                        </div>
                       
                    </div>
                    <div class="kt-portlet__body">
                        <div class="form-body">
                            <div class="form-group row">
                                <label class="col-form-label col-md-3"></label>
                                <div class="col-md-6">
                                    <div class="input-icon right">
                                        <img src="{{substr($config['config']['logo'],0,5) == 'http' ? $config['config']['logo'] :url('Addons/DNS/Resources/assets/'.$config['config']['logo'])}}" width="300">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-form-label col-md-3">
                                {{trans('common.label.status')}}
                                {!! popover( 'dns::app.create_module.status_help','' ) !!}
                                </label>
                                <div class="col-md-6">
                                    <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success">
                                        <label>
                                            <input value="active" type="checkbox" name="status"  @if(isset($dns) && $dns->status=='active') checked="" @endif>
                                        <span></span>
                                        </label>
                                    </span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-form-label col-md-3">{{trans('dns::app.create_module.field.name')}}
                                {!! popover( 'dns::app.create_module.field.name_help','' ) !!}
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                        <input placeholder="{{trans('dns::app.create_module.field.name')}}" type="text" name="name" id="name" value="{{isset($dns)?$dns->name:''}}" class="form-control" />
                                        <span id="name-error" class="error invalid-feedback"></span>
                                        <!-- <small class="desc">{{trans('dns::app.create_module.field.name_desc')}}</small> -->
                                </div>
                            </div>
                            @foreach($config['form'] as $key => $field)
                            <div class="form-group row">
                                <label class="col-form-label col-md-3">{{$field['label']}}
                                    @if($field['description'])
                                {!! popover( $field['description'],'' ) !!}
                                @endif
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                         @if($field['type']=="checkbox")
                                        @foreach( $field['options'] as $option)
                                        <input type="{{$field['type']}}" name="{{$field['name']}}[]" id="{{$field['name']}}" value="{{  $option }}" @if( (!isset($auth_data) && $option==$field['default']) || (isset($auth_data) && in_array($option,$auth_data[$field['name']]))) checked @endif class="{{$field['class']}}" /> {{  $option }}
                                        @endforeach
                                        <span id="{{$key}}-error" class="error invalid-feedback"></span>
                                        @elseif($field['type']=="radio")
                                        @foreach( $field['options'] as $option)
                                        <input type="{{$field['type']}}" name="{{$field['name']}}" id="{{$field['name']}}" value="{{  $option }}" @if( (!isset($auth_data) && $option==$field['default']) || (isset($auth_data) && $auth_data[$field['name']] ==$option)) checked @endif class="{{$field['class']}}" /> {{  ucwords(str_replace(['-'],' ',$option)) }}
                                        @endforeach
                                        <span id="{{$key}}-error" class="error invalid-feedback"></span>
                                        @elseif($field['type']=="select")
                                        <select  name="{{$field['name']}}" id="{{$field['name']}}"  @if($field['width']) style="width: {{$field['width']}} !important"  @endif class="{{$field['class']}}">
                                             @foreach( $field['options'] as $option)
                                             <option value="{{  $option }}" @if( (!isset($auth_data) && $option==$field['default']) || (isset($auth_data) && $auth_data[$field['name']] ==$option)) selected @endif>{{  ucwords(str_replace(['-'],' ',$option)) }}</option>
                                             @endforeach
                                        </select>
                                        <span id="{{$key}}-error" class="error invalid-feedback"></span>
                                         @elseif($field['type']=="textarea")
                                         <textarea name="{{$field['name']}}"  placeholder="{{$field['label']}}" class="{{$field['class']}}" rows="8" cols="8" @if($field['width']) style="width: {{$field['width']}} !important"  @endif>{{isset($auth_data) ? $auth_data[$field['name']]: $field['default']}}</textarea>
                                        @else
                                        @if(!empty($field['insertTop']))
                                        @foreach( $field['insertTop'] as $top)

                                            @foreach( $top['options'] as $option)
                                            <input type="{{$top['type']}}" name="{{$top['name']}}" value="{{  $option }}" @if( (!isset($auth_data) && $option==$top['default']) || (isset($auth_data) && $auth_data[$top['name']] ==$option)) checked @endif class="{{$top['class']}}" /> {{  ucwords(str_replace(['-'],' ',$option)) }}
                                            @endforeach
                                        @endforeach
                                        @endif
                                        <input placeholder="{{$field['label']}}" type="{{$field['type']}}" name="{{$field['name']}}" id="{{$field['name']}}" value="{{isset($auth_data)?$auth_data[$field['name']]: $field['default']}}" @if($field['width']) style="width: {{$field['width']}} !important"  @endif class="{{$field['class']}}" />
                                        <span id="{{$key}}-error" class="error invalid-feedback"></span>
                                        @endif
                                </div>
                            </div>
                            @endforeach
                            @endif
                           
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <label class="col-form-label col-md-3"></label>
                                <div class="col-md-6">
                             {{--       <button type="button" onclick="validateCredentials()" class="btn btn-info" >{{trans('Validate')}}</button>--}}
                                    @if (isset($operations['install']) && $operations['install'])
                                        <button type="button" data-form="install" class="btn btn-success sb" value="install">{{trans('common.form.buttons.add')}}</button>
                                    @elseif (isset($operations['update']) && $operations['update'])
                                        <button type="button" data-form="update" class="btn btn-success sb" value="update">{{trans('common.form.buttons.update')}}</button>
                                    @endif
                                    <a href="{{ route('dnsModules') }}"><button type="button" class="btn btn-default">{{trans('common.form.buttons.cancel')}}</button></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <!-- END FORM-->
    </div>
@endsection
