@extends(decide_template())

@section('title', trans('dns::app.index.title'))

@section('page_styles')
    <link rel="stylesheet" type="text/css" href="{{ url('Addons/DNS/Resources/assets/css/view-dns.css') }}">
@endsection

@section('page_scripts')
    <script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
    <script src="/themes/default/js/includes/common.js" type="text/javascript"></script>
    <script>
        $('#providers').DataTable();
        function ActivateOrDeactivate(id) {
            $.ajax({
                type: 'post',
                url: '{{route('activateOrDeactivate')}}',
                data:{'id':id},
                cache: false,
                dataType: 'json',
                beforeSend: function() {
                    $('.blockUI').show();
                },
                success: function (data) {
                    $('.blockUI').hide();
                    if(data.status==false)
                        toastr.error(data.message);
                   else
                        toastr.success(data.message);

                },complete: function (data) {

                    $('.blockUI').hide();
                }
            });
        }
        function launchModel(id) {
            var alert_msg = '{{trans('dns::app.confirmation')}}';
            $.ajax({
                type: 'post',
                url: '{{route('getDnsToDelete')}}',
                data:{'id':id},
                cache: false,
                dataType: 'json',
                beforeSend: function() {
                    $('.blockUI').show();
                },
                success: function (data) {
                    $('.blockUI').hide();
                    $('#alert-text').html(alert_msg);
                    if(data.toastr_error!==undefined)
                        toastr.error(data.toastr_error);
                    if(data.message!==undefined)
                        $('#alert-text').html(data.message);
                    if(data.method!==undefined)
                    {
                        $('#delete').attr('onclick',data.method);
                        if(data.force)
                            $('#delete').html('{{ trans("dns::app.delete_forcefully")}}');
                        else
                            $('#delete').html('{{ trans("common.form.buttons.yes")}}')
                        $('#confirmationModal').modal("show");
                    }

                },complete: function (data) {

                    $('.blockUI').hide();
                        console.log(data);
                }
            });
        }
        $('.no').click(function () {
            $('#confirmationModal').modal("hide");
        });
        function deleteDns(id,force_fully=0) {
            $.ajax({
                type: 'delete',
                url: '{{route('dnsModuleDelete','')}}/'+id,
                data:{'force_fully':force_fully},
                cache: false,
                dataType: 'json',
                beforeSend: function() {
                    $('.blockUI').show();
                },
                success: function (data) {
                    $('.blockUI').hide();
                    if(data.status) {
                        toastr.success(data.message);
                        $('#r_'+id).slideUp('slow');
                        $('#confirmationModal').modal("hide");
                    }
                    else
                        toastr.error(data.message);

                },complete: function (data) {
                    $('.blockUI').hide();
                }
            });
        }
    </script>
@endsection

@section(decide_content())

    <div id="error" class="alert alert-danger" style="display: none">

    </div>

    <!-- will be used to show any messages -->

    <div id="success" class="alert alert-success" style="display: none">

    </div>

    <!-- will be used to show any messages -->
    <div id="msg" class="display-hide">
        <button class="close" data-close="alert"></button>
        <span id='msg-text'><span>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="kt-portlet kt-portlet--height-fluid">
                <div class="kt-portlet__body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="tabbable tabbable-tabdrop">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a href="#tab1" class="nav-link active" data-toggle="tab">{{ trans("dns::app.all")}}</a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="#tab2" class="nav-link" data-toggle="tab">{{ trans("dns::app.connected")}}</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab1">
                                        <div class="row ">
                                            @if(!empty($configs))
                                            @foreach($configs as $key => $config)
                                                <div class="col-md-2">
                                                    <div class="mainBlk">
                                                        <a href="{{ route('dnsModuleCreate', $configs[$key][1]) }}">
                                                            <img src="{{substr($configs[$key][0]['config']['logo'],0,5) == 'http' ? $configs[$key][0]['config']['logo'] :url('Addons/DNS/Resources/assets/'.$configs[$key][0]['config']['logo'])}}">
                                                        </a>
                                                        <div class="smtpName">
                                                            {{$configs[$key][0]['config']['name']}}
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                            @else
                                                <div class="alert alert-warning">
                                                    <div class="alert-text">
                                                    Providers not found
                                                        
                                                    </div>
                                                </div>
                                                @endif
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tab2">
                                        <div class="col-md-12">
                                            <table class="table table-striped table-hover table-checkable responsive" id="providers" role="grid" >
                                                <thead>
                                                <tr role="row">
                                                    <th width="30%">{{trans('dns::app.th.friendly_name')}}</th>
                                                    <th>{{trans('dns::app.th.connected_on')}}</th>
                                                    <th>{{trans('dns::app.th.status')}}</th>
                                                    <th>{{trans('dns::app.th.actions')}}</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                             @foreach($addons as $addon)

                                                        <tr id="r_{{$addon->id}}">
                                                            <td width="30%" class="text-center">
                                                                <img width="200" src="{{substr($configs[$addon->class_name][0]['config']['logo'],0,5) == 'http' ? $configs[$addon->class_name][0]['config']['logo'] :url('Addons/DNS/Resources/assets/'.$configs[$addon->class_name][0]['config']['logo'])}}">
                                                                <br>
                                                                {{$addon->name}}
                                                            </td>
                                                            <td>{{$addon->created_at}}</td>
                                                            <td>
                                                        <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success">
                                                            <label>
                                                                <input onchange="ActivateOrDeactivate({{$addon->id}})" type="checkbox" id="status_{{$addon->id}}" {{$addon->status=='active'?'checked':''}}>
                                                                <span></span>
                                                            </label>
                                                        </span>
                                                            </td>
                                                            <td>
                                                                <div class="dropdown">
                                                                    <a class="btn btn-label-success btn-icon btn-sm btn-icon-md" data-toggle="dropdown" aria-expanded="false"><i class="flaticon-more-1"></i>
                                                                    </a>
                                                                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                                                        
                                                                        <li>
                                                                            <a href="{{route('dnsModuleEdit',$addon->id)}}"> <i class="la la-eye"></i> Edit</a>
                                                                        </li>
                                                                        <li>
                                                                            <a href="javascript:;" onclick="launchModel({{$addon->id}})"> <i class="la la-close"></i> {{ trans("common.form.buttons.delete")}}</a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </td>
                                                        </tr>

                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>

    <div id="confirmationModal" class="modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-modal="true" style="padding-right: 17px; display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ trans("dns::app.delete_confirmation")}}</h5>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning adminOnClient" style="display: none;">

                    </div>
                    <div class="form-actions">
                                        <span id="split-processing">
                                <div class="text-danger" id="alert-text"></div>
                            </span>
                        <div class="row">
                            <div class="offset-md-3 col-md-7">
                                <button id="delete" class="btn btn-danger" >{{ trans("common.form.buttons.yes")}}</button>
                                <button class="no btn btn-default">{{ trans("common.form.buttons.no")}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection