
<div class="modal fade" id="providers-modal" tabindex="-1" role="dialog" aria-labelledby="integration" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">{{trans('dns::app.modal.Auto_Update_DNS')}}</h5>
            </div>
            <div class="modal-body">
                @if(count($dns_list)==0)
                    <div class="nodns text-center">
                        <div id="alert_msg" class="alert alert-warning fade show" role="alert">
                            <div class="alert-icon"><i class="flaticon-warning"></i></div>
                            <div class="alert-text kt-font-bold">{!! trans('dns::app.modal.no_provider_exists',['here'=>'<a href="'.route('dnsModules').'">here</a>']) !!}</div>
                        </div>
                    </div>
                @else
                    <div id="alert_msg_" class=""></div>


                    <form action="" method="POST" id="attachProvider" name="attachProvider" class="kt-form kt-form--label-right" novalidate="novalidate">
                        <input type="hidden" name="_token"  value="{{ csrf_token() }}" />
                        <input type="hidden" id="attached"  value="">
                        <input type="hidden" id="domain_id" name="domain_id" value="{{ ($domain_id)? $domain_id:0}}">
                        <input  type="hidden" name="up_fdns" id="up_fdns"  value="1">
                        @if(count($dns_list)>0)
                            <div id="fdns_div" class="form-group row" >
                                <label class="col-form-label col-md-3">
                                {{trans('dns::app.modal.select_provider')}}
                                {!! popover( 'dns::app.modal.select_provider_help','' ) !!}
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                    <div class="input-icon right">
                                        <select class="form-control m-select2" id="fdns" name="fdns" data-placeholder="{{trans('app.integration.select.provider')}}">
                                            <option value=""> {{trans('dns::app.modal.select_provider')}}</option>
                                            @foreach($dns_list as $dnsIntegration)
                                                <option value="{{$dnsIntegration->id}}" {{ $dns && $dns->dns_id == $dnsIntegration->id?'selected':''}} >{{ $dnsIntegration->name }}</option>
                                            @endforeach
                                        </select>
                                        <span id="fdns-error" class="error"></span>
                                    </div>
                                </div>
                                <span style="display: none" class="spinner spinner_1"><i class="fa fa-spinner fa-spin"></i></span>
                            </div>
                        @endif
                        <div id="fdns_list_div" class="form-group row" style="{{!$dns ?'display:none':''}}">
                            <label class="col-form-label col-md-3">{{trans('dns::app.modal.select_domain')}}
                            {!! popover( 'dns::app.modal.select_domain_help','' ) !!}
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-6">
                                <div class="input-icon right">
                                    <select class="form-control m-select2" id="fdns_zone" name="fdns_zone" >
                                        @if($dns && $dns->zone!=null)
                                            <option selected value="{{$dns->zone}}">{{$dns->zone}}</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <span id="spin_1"><i class="la la-refresh"></i></span>
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <label class="col-form-label col-md-3"></label>
                                <div class="col-md-6">
                                    <button type="button" name="save" id="dns_save" class="btn btn-success" value="save">{{trans('dns::app.modal.save_button')}}</button>
                                    {{--<a href="{{ route('admin.view.ip.blocks') }}"><button type="button" class="btn btn-default">{{trans('common.form.buttons.cancel')}}</button></a>--}}
                                </div>
                            </div>
                        </div>
                    </form>
                @endif
            </div>
            <div class="modal-footer">
                <button id="dismiss_btn" type="button" class="btn btn-default" data-dismiss="modal">{{trans('common.form.buttons.close')}}</button>
            </div>
        </div>
    </div>
</div>

<style>
#spin_1 i {
    margin: 7px 0;
    font-weight: bold;
    font-size: 15px;
    background: #08976D;
    padding: 5px;
    color: white;
    border-radius: 3px;
}
#providers-modal .alert-text {
    flex-grow: 0 !important;
}
.spinner.spinner_1{
    align-self: center;
}
</style>