@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
<link href="{{ url('Addons/DNS/Resources/assets/css/registrars.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('page_scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $(".activate,.deactivate").click(function() {
            var data={
             status: $(this).data('status'),
             class_name: $(this).data('class'),
            };
             $.ajax({
                    type: 'POST',
                    url: '{{ route("activateOrDeactivateProvider") }}',
                    data: data,
                    cache: false,
                    dataType: 'json',
                    context: this,
                    beforeSend: function() {
                        $(".blockUI").show();
                    },
                    success: function (data) {
                        $(".blockUI").hide();
                        if (data.status == true) {
                            if($(this).hasClass('activate')){
                              $(this).parent("td").addClass("active");
                              Command: toastr["success"] ("The selected module activated successfully");  
                            }else{
                                $(this).parent("td").removeClass("active");
                                 Command: toastr["success"] ("The selected module deactivated successfully");
                            }
                             
                        } else {
                            Command: toastr["error"] (data.msg);
                        }
                        return false;
                    }
                });
            
            
        });
        
    });
</script>
@endsection

@section(decide_content())

<div class="row">
    <div class="col-md-8 create-form">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="kt-portlet kt-portlet--height-fluid">
            <div class="kt-portlet__body">
                <table class="table table-striped table-checkable responsive" id="modules">
                	<thead>
                		<tr>
                			<th colspan="3">@lang('dns::app.providers.all')</th>
                		</tr>
                	</thead>
                	<tbody>
                         @if(!empty($configs))
                        @foreach($configs as $config)
                                               <tr>
                            <td width="200px">
                                <img src="{{substr($config[0]['config']['logo'],0,5) == 'http' ? $config[0]['config']['logo'] :url('Addons/DNS/Resources/assets/'.$config[0]['config']['logo'])}}" alt="{{$config[0]['config']['name']}}">
                            </td>
                            <td>{{$config[0]['config']['name']}} <span>{{$config[0]['config']['description']}}</span></td>
                            <td class="@if(!$config[2] ||($config[2] && $config[2]->status==1)) active @endif" width="250px" >
                                <button class="btn btn-success btn-sm activate" data-status="1" data-class="{{$config[1]}}">@lang('dns::app.providers.activate')</button>
                                <button class="btn btn-default btn-sm deactivate" data-status="0" data-class="{{$config[1]}}">@lang('dns::app.providers.deactivate')</button>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <div class="alert alert-warning">
                            <div class="alert-text">
                            @lang('dns::app.providers.not_found')
                                
                            </div>
                        </div>
                        @endif
                                      
                		
                		
                	</tbody>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

@endsection