<?php
use Addons\DNS\Helper\Common;
use App\Helpers\AddonLicense;

    /*
    |--------------------------------------------------------------------------
    | Mynewaddon Dependencies Check
    |--------------------------------------------------------------------------
    |
    | Check for the required dependencies before initiating the update
    |
    */
    function dns_checkDependency() {

	   # Your code goes here...
	   
	   $msg = "success";	// Returns the operation response. If it's not success then an error will be shown resulting the operation failure
	   return $msg;
   }
   /*
    |--------------------------------------------------------------------------
    | Mynewaddon License Check
    |--------------------------------------------------------------------------
    |
    | If your addon requires a license key to be checked before running the
    | update process then write your code below
    |
    */
    function dns_checkLicense($request=null) {
       
        try { 
            $licenseKey='';
            $localKey='';
            $configFile = addonSettingDir('DNS') . DIRECTORY_SEPARATOR . 'config.php'; // addonSettingDir() return path upto addon "Setting" directory
            if (!file_exists($configFile)) 
            throw new \Exception("Config file $configFile not exists", 1);
            include $configFile;
            $item_code=isset($setting['item_code']) ? $setting['item_code']:''; 
            if($request==null){
               $localKey=isset($setting['local_key']) ? $setting['local_key']:'';   
               $licenseKey=isset($setting['license_key']) ? $setting['license_key']:''; 
              
            }else{
                $licenseKey=$request->key;
            }

           
            if(empty($licenseKey))
                throw new \Exception(trans('addons.message.license_key_not_found'), 1);
                
                $license_result = AddonLicense::checkAddonLicense($licenseKey, $localKey , $item_code);
                // print_r($license_result);exit;
                if($license_result['status'] !="Active")
                throw new \Exception($license_result['status'].": ".($license_result['message'] ?? ''), 1);
                $localKey=isset($license_result['localkey']) ? $license_result['localkey']:''; 
                if($localKey) {
                    $file = array_filter(array_map('trim', file($configFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)));
                    // Deleting existing local key
                    foreach($file as $key => $value) {
                        $pattern = preg_quote('local_key', '/');
                        // finalise the regular expression, matching the whole line
                        $pattern = "/^.*$pattern.*\$/m";
                        if (preg_match($pattern,$value)){
                            unset($file[$key]);
                            break;
                        }
                    }
                    $file=array_values($file);
                    // Inserting local key
                    $file = array_slice($file, 0, 10, true) + array(count($file) => '"local_key" => "'.$localKey.'",') + array_slice($file, 10, count($file)-10, true);
                    $file=array_values($file);
                       file_put_contents($configFile,implode(PHP_EOL, $file));
                     
                }  
            
          $msg = "success";
        } catch (\Exception $e) {
              $msg = $e->getMessage();
        }
        
	   
	 	// Returns the operation response. If it's not success then an error will be shown resulting the operation failure
	   return $msg;
   }

    /**
     * This function will be executed before starting the update operation
     * This can be used if you have a vetting system before creating/downloading the zip file
     * On success, it should return (array) ['success'=>true,'update_url' => "http://yourdomain.com/version/1.0.zip"];
     * On failed, it should return  (array) ['success'=>false,'message' => 'Message to show'];
     */
     function update_addon(){

         try {
                $checkLic=dns_checkLicense();
                $checkDep=dns_checkDependency();
                if($checkDep != 'success'){ // If the response isn't "success", it means the operation has failed
                     throw new \Exception($checkDep, 1);
                }elseif($checkLic != 'success'){ // If the response isn't "success", it means the operation has failed
                     throw new \Exception($checkLic, 1);
                }else{

                    // Including addon config file from addon "Setting" directory
                    // addonSettingDir() returns the path to the addon's settings directory
                    $configFile = addonSettingDir('DNS') . DIRECTORY_SEPARATOR . 'config.php'; // addonSettingDir() return path upto addon "Setting" directory
                    if (!file_exists($configFile)) 
                    throw new \Exception("Config file $configFile not exists", 1);
                    include $configFile;

                    if(isset($setting['update_url']) && !empty($setting['update_url'])){ // Checking update url in config.php file

                          $response=['success'=>true,'update_url' => $setting['update_url']];  // success

                    }else{

                        // Code here
                          $response=['success'=>true,'update_url' => "http://your_domain.com/addons/addon_name/DNS.zip"];  // success
                          // Note: Addon name , addon zip file name and folder name inside the zip must be same 
                    }
                }
                
            } catch (\Exception $e) {
                 $response=['success'=>false,'message' => $e->getMessage()]; 
            }
        return $response;
    }

    /**
     * This function will be executed before starting the installation operation
     * @return
     * On success, it should return (array) ['success'=>true,'message' => "Message to show"];
     * On failed, it should return    (array) ['success'=>false,'message' => 'Message to show'];
     */
     function install_addon(){

         try {
                $checkLic=dns_checkLicense();
                $checkDep=dns_checkDependency();
                if($checkDep != 'success'){ // If the response isn't success, it means the operation has been failed
                     throw new \Exception($checkDep, 1);
                }elseif($checkLic != 'success'){ // If the response isn't success, it means the operation has been failed
                     throw new \Exception($checkLic, 1);
                }else{
                // Code here
                  $response=['success'=>true,'message' => "Success"];  // success   
                }
            } catch (\Exception $e) {
                 $response=['success'=>false,'message' => $e->getMessage()]; 
            }
            

        return $response;
    }


